/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.network.packet;

import dev.toma.gunsrpg.api.common.data.ISkillProvider;
import dev.toma.gunsrpg.api.common.skill.IClickableSkill;
import dev.toma.gunsrpg.api.common.skill.ISkill;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.init.ModRegistries;
import dev.toma.gunsrpg.common.skills.core.SkillType;
import dev.toma.gunsrpg.network.AbstractNetworkPacket;
import dev.toma.gunsrpg.util.SkillUtil;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class C2S_SkillClickedPacket
extends AbstractNetworkPacket<C2S_SkillClickedPacket> {
    private SkillType<?> type;

    public C2S_SkillClickedPacket() {
    }

    public <S extends ISkill & IClickableSkill, T extends SkillType<S>> C2S_SkillClickedPacket(T type) {
        this.type = type;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_192572_a(this.type.getRegistryName());
    }

    @Override
    public C2S_SkillClickedPacket decode(PacketBuffer buffer) {
        ResourceLocation path = buffer.func_192575_l();
        return new C2S_SkillClickedPacket(C2S_SkillClickedPacket.fromRegistry(path));
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        if (this.type == null || this.type.isDisabled()) {
            return;
        }
        PlayerData.get((PlayerEntity)player).ifPresent(data -> {
            ISkillProvider provider = data.getSkillProvider();
            Object skill = SkillUtil.getTopHierarchySkill(this.type, provider);
            IClickableSkill clickable = (IClickableSkill)skill;
            if (clickable.canUse()) {
                clickable.onSkillUsed(player);
            }
        });
    }

    private static <S extends ISkill & IClickableSkill, T extends SkillType<S>> T fromRegistry(ResourceLocation location) {
        SkillType type = (SkillType)ModRegistries.SKILLS.getValue(location);
        Object skill = type.getDataInstance();
        if (!(skill instanceof IClickableSkill)) {
            throw new IllegalArgumentException("Attempted to send click event from skill which doesn't implement the IClickableSkill interface! [" + location + "]");
        }
        return (T)((Object)type);
    }
}

